import UIKit

class MyTile: UIView
{
    // a built-in label
    // a built-in ui image view
    
    var lbl : UILabel!
    var imgViw : UIImageView!
    
    
    var internalNum : Int!
    var internalImage : UIImage!
    
    static var questionTxt = "?"
    static var smileTxt = "🙂"
    
    static var questionImg = UIImage (named: "question.png")
    static var tickImg = UIImage (named: "tick.png")
    
    
    
    
    
    
    init (inpFrame: CGRect, type: TextOrImage)
    {
        super.init(frame: inpFrame)
        lbl = UILabel(frame: self.frame)
        lbl.font = UIFont.systemFont(ofSize: 50,
                                     weight: UIFont.Weight.bold)
        lbl.textAlignment = NSTextAlignment.center
        lbl.text = "\(MyTile.questionTxt)"
        
        imgViw = UIImageView(frame: self.frame)
        imgViw.image = MyTile.questionImg
        
        if type == TextOrImage.text
        {
            self.addSubview(lbl)
        }
        else
        {
            self.addSubview(imgViw)
        }
    }
    
    
    
    
    
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
